/*
 * Decompiled with CFR 0.152.
 */
package jace.apple2e;

import jace.config.ConfigurableField;
import jace.core.Computer;
import jace.core.Device;
import jace.core.Motherboard;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import jace.core.SoundMixer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class Speaker
extends Device {
    static boolean fileOutputActive = false;
    static OutputStream out;
    private double counter = 0.0;
    private int level = 0;
    private int idleCycles = 0;
    static int BUFFER_SIZE;
    static int MIN_PLAYBACK_BUFFER;
    private int MIN_SAMPLE_PLAYBACK = BUFFER_SIZE / 4;
    @ConfigurableField(name="Speaker Volume", description="Should be under 1400")
    public static int VOLUME;
    @ConfigurableField(name="Idle cycles before sleep")
    public static int MAX_IDLE_CYCLES;
    private SourceDataLine sdl;
    private boolean speakerBit = false;
    private final Object bufferLock = new Object();
    byte[] soundBuffer1;
    byte[] soundBuffer2;
    int currentBuffer = 1;
    int bufferPos = 0;
    private double TICKS_PER_SAMPLE = (double)Motherboard.SPEED / (double)SoundMixer.RATE;
    private double TICKS_PER_SAMPLE_FLOOR = Math.floor(this.TICKS_PER_SAMPLE);
    Thread playbackThread;
    private RAMListener listener = new RAMListener(RAMEvent.TYPE.ANY, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

        @Override
        public boolean isRelevant(RAMEvent e) {
            return true;
        }

        @Override
        protected void doConfig() {
            this.setScopeStart(49200);
            this.setScopeEnd(49215);
        }

        @Override
        protected void doEvent(RAMEvent e) {
            if (e.getType() == RAMEvent.TYPE.WRITE) {
                Speaker.this.level += 2;
            } else {
                Speaker.this.speakerBit = !Speaker.this.speakerBit;
            }
            Speaker.this.resetIdle();
        }
    };

    public static void toggleFileOutput() {
        if (fileOutputActive) {
            try {
                out.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Speaker.class.getName()).log(Level.SEVERE, null, ex);
            }
            out = null;
            fileOutputActive = false;
        } else {
            int i;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.showSaveDialog(null);
            File f = fileChooser.getSelectedFile();
            if (f == null) {
                return;
            }
            if (f.exists() && (i = JOptionPane.showConfirmDialog(null, "Overwrite existing file?")) != 0 && i != 0) {
                return;
            }
            try {
                out = new FileOutputStream(f);
                fileOutputActive = true;
            }
            catch (IOException ex) {
                Logger.getLogger(Speaker.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public Speaker() {
        this.configureListener();
        this.reconfigure();
    }

    @Override
    public void suspend() {
        this.setRun(false);
        this.speakerBit = false;
        if (this.playbackThread != null && this.playbackThread.isAlive()) {
            this.playbackThread = null;
        }
        Motherboard.mixer.returnLine(this);
    }

    @Override
    public void resume() {
        this.sdl = null;
        try {
            this.sdl = Motherboard.mixer.getLine(this);
        }
        catch (LineUnavailableException ex) {
            System.out.println("ERROR: Could not output sound: " + ex.getMessage());
        }
        if (this.sdl != null) {
            this.setRun(true);
            this.counter = 0.0;
            this.idleCycles = 0;
            this.level = 0;
            this.bufferPos = 0;
            if (this.playbackThread == null || !this.playbackThread.isAlive()) {
                this.playbackThread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        int len = 0;
                        Motherboard.requestSpeed(this);
                        while (Speaker.this.isRunning()) {
                            len = Speaker.this.bufferPos;
                            if (len >= Speaker.this.MIN_SAMPLE_PLAYBACK) {
                                byte[] buffer;
                                Object object = Speaker.this.bufferLock;
                                synchronized (object) {
                                    len = Speaker.this.bufferPos;
                                    buffer = Speaker.this.currentBuffer == 1 ? Speaker.this.soundBuffer1 : Speaker.this.soundBuffer2;
                                    Speaker.this.currentBuffer = Speaker.this.currentBuffer == 1 ? 2 : 1;
                                    Speaker.this.bufferPos = 0;
                                }
                                Speaker.this.sdl.start();
                                Speaker.this.sdl.write(buffer, 0, len);
                                if (!fileOutputActive || out == null) continue;
                                try {
                                    out.write(buffer, 0, len);
                                }
                                catch (IOException ex) {
                                    Logger.getLogger(Speaker.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                continue;
                            }
                            LockSupport.parkNanos(5000L);
                        }
                        Speaker.this.sdl.drain();
                        Speaker.this.sdl.flush();
                        Motherboard.cancelSpeedRequest(this);
                    }
                });
                this.playbackThread.start();
            }
        }
    }

    public void resetIdle() {
        this.idleCycles = 0;
        if (!this.isRunning()) {
            this.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tick() {
        if (!this.isRunning()) {
            return;
        }
        if (this.idleCycles++ >= MAX_IDLE_CYCLES) {
            this.suspend();
        }
        if (this.speakerBit) {
            ++this.level;
        }
        this.counter += 1.0;
        if (this.counter >= this.TICKS_PER_SAMPLE) {
            while (this.bufferPos >= BUFFER_SIZE) {
                LockSupport.parkNanos(1000L);
            }
            int sample = this.level * VOLUME;
            byte[] buf = null;
            Object object = this.bufferLock;
            synchronized (object) {
                buf = this.currentBuffer == 1 ? this.soundBuffer1 : this.soundBuffer2;
                int bytes = SoundMixer.BITS >> 3;
                int shift = SoundMixer.BITS;
                int index = this.bufferPos;
                int i = 0;
                while (i < SoundMixer.BITS) {
                    byte by = (byte)(sample >> (shift -= 8) & 0xFF);
                    buf[index + bytes] = by;
                    buf[index] = by;
                    i += 8;
                    ++index;
                }
                this.bufferPos += bytes * 2;
            }
            this.level = 0;
            this.counter -= this.TICKS_PER_SAMPLE_FLOOR;
        }
    }

    private void configureListener() {
        Computer.getComputer().getMemory().addListener(this.listener);
    }

    private void removeListener() {
        Computer.getComputer().getMemory().removeListener(this.listener);
    }

    @Override
    protected String getDeviceName() {
        return "Speaker";
    }

    @Override
    public void reconfigure() {
        BUFFER_SIZE = (int)((double)SoundMixer.RATE * 0.2) * (SoundMixer.BITS >> 3);
        MIN_PLAYBACK_BUFFER = BUFFER_SIZE / 2;
        this.MIN_SAMPLE_PLAYBACK = BUFFER_SIZE / 4;
        this.soundBuffer1 = new byte[BUFFER_SIZE];
        this.soundBuffer2 = new byte[BUFFER_SIZE];
    }

    @Override
    public void attach() {
        this.configureListener();
        this.resume();
    }

    @Override
    public void detach() {
        this.removeListener();
        this.suspend();
    }

    static {
        BUFFER_SIZE = (int)((double)SoundMixer.RATE * 0.4);
        MIN_PLAYBACK_BUFFER = BUFFER_SIZE / 2;
        VOLUME = 600;
        MAX_IDLE_CYCLES = 2000000;
    }
}

